
#ifndef CLUSTERVOLUMEPLUGIN_H
#define CLUSTERVOLUMEPLUGIN_H

#include <CompuCell3D/Plugin.h>
#include <CompuCell3D/Potts3D/Stepper.h>
#include <CompuCell3D/Potts3D/EnergyFunction.h>
#include <CompuCell3D/Potts3D/CellGChangeWatcher.h>
#include <CompuCell3D/Potts3D/Cell.h>
#include <CompuCell3D/Automaton/Automaton.h>
#include "../ClusterDataTrackerPlugin/ClusterDataTrackerPlugin.h"
#include <BasicUtils/BasicClassAccessor.h>

#include <vector>
#include <string>

class CC3DXMLElement;

template <typename Y> class BasicClassAccessor;
namespace CompuCell3D {
  class Potts3D;
  class CellG;
  class ClusterDataTrackerPlugin;

  class ClusterVolumePlugin : public Plugin , public EnergyFunction 
  {
	Potts3D *potts;
	CC3DXMLElement *xmlData;
    Automaton *automaton;
  public:
    //Accessing cell-attached data structures (extraAttrib)		

    BasicClassAccessor <ClusterDataTrackerPlugin> *clusterDataTrackerAccessorPtr;
       ClusterDataTrackerPlugin *clusterDataTrackerPlugin;

    ClusterVolumePlugin():potts(0){};
    virtual ~ClusterVolumePlugin(){};

	//EnergyFunction interface
	virtual double changeEnergy(const Point3D &pt, const CellG *newCell,const CellG *oldCell);

    // SimObject interface
	virtual void init(Simulator *simulator, CC3DXMLElement *_xmlData);
    virtual void update(CC3DXMLElement *_xmlData, bool _fullInitFlag=false);
    virtual std::string steerableName();
	virtual std::string toString();

  };
};
#endif





